/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareEvent0405Rule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0405RuleBase;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class HardwareEvent0405XMLParser
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private static final String TAG_HER_RULEBASE = "Hde-rulebase";
    private static final String TAG_HER_RULE = "Hde-rule";
    private static final String TAG_PRIORITY = "PRIORITY";
    private static final String TAG_SERVICE = "SERVICE";
    private static final String TAG_TRANSMIT = "TRANSMIT";
    private static final String TAG_REFCODE = "REFCODE";
    private static final String TAG_MESSAGES = "MESSAGES";
    private static final String TAG_MESSAGE_NUMBER = "MESSAGE_NUMBER";
    private static final String TAG_TRUE = "TRUE";
    public static final String RULEBASE_ISC = "rulebase_isc.xml";
    public static final String RULEBASE_ESCON = "/home/wmdovin/javahmc/linuxhmc/data/pa/test.xml";

    public HardwareEvent0405XMLParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "HardwareEvent0405XMLParser.ctor");
    }

    public static HardwareEvent0405RuleBase parseXML(String fileName) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "HardwareEvent0405XMLParser.parseXML(" + fileName + ")");
        return HardwareEvent0405XMLParser.parseXML(new File(fileName));
    }

    public static HardwareEvent0405RuleBase parseXML(File file) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "HardwareEventXMLParser.parseXML(" + file + ")");
        try {
            HardwareEvent0405XMLParser parser = new HardwareEvent0405XMLParser();
            if (parser != null) {
                Trace.trace(TRACE_MASKD, "acquired parser next open file " + file);
            } else {
                Trace.trace(TRACE_MASKD, "could not acquired parser");
            }
            InputSource xmlSource = new InputSource(new FileInputStream(file));
            if (xmlSource != null) {
                Trace.trace(TRACE_MASKD, "have a file");
            } else {
                Trace.trace(TRACE_MASKD, "could not acquired file");
            }
            parser.parse(xmlSource);
            Trace.trace(TRACE_MASKD, "parser.parse file");
            Document doc = parser.getDocument();
            if (doc != null) {
                Trace.trace(TRACE_MASKD, "got the Document");
            } else {
                Trace.trace(TRACE_MASKD, "no Document");
            }
            NodeList root = doc.getElementsByTagName(TAG_HER_RULEBASE);
            Trace.trace(TRACE_MASKD, "nodelist length" + root.getLength());
            HardwareEvent0405RuleBase rb = null;
            if (root.getLength() != 1) {
                Trace.trace(TRACE_MASKD, "too many Nodes");
                throw new MalformedXMLException("A single <Hde-rulebase> is expected.");
            }
            rb = HardwareEvent0405XMLParser.parseRulebase(root.item(0));
            return rb;
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (ClassNotFoundException e) {
            throw new MalformedXMLException("ClassNotFoundException!");
        }
        catch (SAXParseException e) {
            throw new MalformedXMLException("SaxParseException! " + CommonXMLParser.where(e));
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
    }

    private static HardwareEvent0405RuleBase parseRulebase(Node node) throws ClassNotFoundException, MalformedXMLException {
        HardwareEvent0405RuleBase rb = new HardwareEvent0405RuleBase();
        NodeList children = node.getChildNodes();
        Trace.trace(TRACE_MASKD, "Children nodelist length = " + children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            Trace.trace(TRACE_MASKD, "child element node = " + child.getNodeType() + " child value =" + child.getNodeValue() + " child name =" + child.getNodeName());
            if (child.getNodeType() == 1) {
                if (child.getNodeName().toLowerCase().equals(TAG_HER_RULE.toLowerCase())) {
                    rb.addRule(HardwareEvent0405XMLParser.parseRule(child));
                    Trace.trace(TRACE_MASKD, "Added rule");
                } else {
                    Trace.trace(TRACE_MASKD, "Error parsing HardwareEventRuleBase");
                    throw new MalformedXMLException("Unknown tag ??? " + child.getNodeName().toLowerCase());
                }
            }
            ++i;
        }
        return rb;
    }

    private static HardwareEvent0405Rule parseRule(Node node) throws ClassNotFoundException, MalformedXMLException {
        HardwareEvent0405Rule rule = new HardwareEvent0405Rule();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals(TAG_PRIORITY)) {
                    rule.setPriority(CommonXMLParser.gatherTextContents(child));
                    Trace.trace(TRACE_MASKD, "set This rule priority with " + CommonXMLParser.gatherTextContents(child));
                } else if (child.getNodeName().equals(TAG_SERVICE)) {
                    rule.setService(CommonXMLParser.gatherTextContents(child));
                    Trace.trace(TRACE_MASKD, "set This rule service with " + CommonXMLParser.gatherTextContents(child));
                } else if (child.getNodeName().equals(TAG_TRANSMIT)) {
                    rule.setTransmit(CommonXMLParser.gatherTextContents(child));
                    Trace.trace(TRACE_MASKD, "set This rule transmit with " + CommonXMLParser.gatherTextContents(child));
                } else if (child.getNodeName().equals(TAG_MESSAGES)) {
                    Trace.trace(TRACE_MASKD, "set messages with " + CommonXMLParser.gatherTextContents(child));
                    rule.setMessages(CommonXMLParser.gatherTextContents(child));
                } else if (child.getNodeName().equals(TAG_MESSAGE_NUMBER)) {
                    Trace.trace(TRACE_MASKD, "set Message_Number with " + CommonXMLParser.gatherTextContents(child));
                    rule.setMessageNumber(HardwareEvent0405XMLParser.getArrayListOfMessages(CommonXMLParser.gatherTextContents(child)));
                } else {
                    Trace.trace(TRACE_MASKD, "Unknown tage in rule which is to be expected = ");
                }
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "about to set rule.key");
        return rule;
    }

    private static ArrayList getArrayListOfMessages(String messageStr) {
        Trace.trace(TRACE_MASKD, "-->in getArrayListOfMessages " + messageStr);
        ArrayList<String> returnList = new ArrayList<String>();
        boolean finished = false;
        int i = 0;
        int comma = 0;
        messageStr = messageStr.trim();
        while (!finished) {
            comma = messageStr.indexOf(",", i);
            if (comma == -1) {
                finished = true;
                Trace.trace(TRACE_MASKD, "messageBeing Added " + messageStr.trim().substring(i + 1, messageStr.length() - 1));
                returnList.add(messageStr.trim().substring(i + 1, messageStr.length() - 1));
                continue;
            }
            Trace.trace(TRACE_MASKD, "messageBeing Added " + messageStr.trim().substring(i + 1, comma - 1));
            returnList.add(messageStr.trim().substring(i + 1, comma - 1));
            messageStr = messageStr.substring(comma + 1).trim();
            Trace.trace(TRACE_MASKD, "messageStr =  " + messageStr);
        }
        Trace.trace(TRACE_MASKD, "<-- getArrayListOfMessages " + returnList.size());
        return returnList;
    }
}

